#include "registro.h"

#define EMPRESA  "MiEmpresa"
#define PRODUCTO "Ejemplos"
#define VERSION  "1.0"

*** Cargar la Form y mostrarla ***
PUBLIC oEjemplo3
oEjemplo3 = CREATEOBJECT( "Ejemplo3" )
oEjemplo3.Show()
RETURN


*** Form del ejemplo en forma de clase
DEFINE CLASS Ejemplo3 AS FORM

  BackColor = RGB(192,192,192)
  Caption = "Ejemplo sobre Registry"
  Name = "Ejemplo3"

  *** Botn para cerrar ***
  ADD OBJECT cmdAceptar ;
    AS COMMANDBUTTON WITH ;
    Top = 6, ;
    Left = 6, ;
    Height = 29, ;
    Width = 94, ;
    Caption = "Aceptar"

  *** Evento al crear la form ***
  PROCEDURE Load

    *** Cargar las declaraciones ***
    DO Registro

	*** Obtener los valores con ***
    *** los que se cerr la ltima vez ***
	nKey = 0
    WITH This
	  IF RegOpenKeyEx( HKEY_CURRENT_USER, ;
                       "Software\"+;
                         EMPRESA+"\"+;
                         PRODUCTO+"\"+;
                         VERSION+"\"+;
                         .name, ;
                       0, ;
                       KEY_ALL_ACCESS, ;
                       @nKey ) == NO_ERROR
			 
        nType = 0
        cValor = REPLICATE( CHR(0), 4 )
	    =RegQueryValueEx( nKey, "Top", 0, ;
	                      @nType, @cValor, 4 )
        .Top = CTOWORD(cValor)
	    nValor = 0
	    =RegQueryValueEx( nKey, "Left", 0, ;
	                      @nType, @cValor, 4 )
    	.Left = CTOWORD(cValor)
	    nValor = 0
	    =RegQueryValueEx( nKey, "Width", 0, ;
	                      @nType, @cValor, 4 )
    	.Width = CTOWORD(cValor)
	    nValor = 0
	    =RegQueryValueEx( nKey, "Height", 0, ;
	                      @nType, @cValor, 4 )
    	.Height = CTOWORD(cValor)
      ENDIF
    ENDWITH
  ENDPROC

  *** Evento al destruir la form ***
  PROCEDURE Unload

    *** Cargar las declaraciones ***
    *** pueden haberse descargado ***
    DO registro
    
    *** Si est minimizado o maximizado ***
    *** restaurar al tamao normal ***
    This.WindowState = 0
    
    
    *** Abrir o crear la clave si no existe
    nKey = 0
    nResult = 0
    WITH This
      
      IF RegCreateKeyEx( HKEY_CURRENT_USER, ;
                         "Software\"+;
                           EMPRESA+"\"+;
                           PRODUCTO+"\"+;
                           VERSION+"\"+;
                           .name, ;
                         0, ;
                         0, ;
                         REG_OPTION_NON_VOLATILE, ;
                         KEY_ALL_ACCESS, ;
                         0,;
                         @nKey, ;
                         @nResult ) == NO_ERROR

        *** Guardar los valores de ***
        *** posicin y tamao ***
        = RegSetValueEx( nKey, "Top", 0, ;
                         REG_DWORD, WORDTOC(.Top), 4 )
        = RegSetValueEx( nKey, "Left", 0, ;
                         REG_DWORD, WORDTOC(.Left), 4 )
        = RegSetValueEx( nKey, "Width", 0, ;
                         REG_DWORD, WORDTOC(.Width), 4 )
        = RegSetValueEx( nKey, "Height", 0, ;
                         REG_DWORD, WORDTOC(.Height), 4 )
      ENDIF
    ENDWITH
  ENDPROC

  *** Mtodo para cerrar la form
  PROCEDURE cmdAceptar.Click
    ThisForm.Release()
  ENDPROC

ENDDEFINE

*** Combierte un nmero en un buffer
PROCEDURE WORDTOC
LPARAMETER nNumber
RETURN chr( BITAND( 255, nNumber ) ) + ;
       chr( BITAND( 65280, nNumber ) % 255 ) + ;
       chr( BITAND( 16711680, nNumber ) % 255 ) + ;
       chr( BITAND( 4278190080, nNumber ) % 255 )

*** Combierte un buffer en un nmero
PROCEDURE CTOWORD
LPARAMETER cBuffer
RETURN asc( substr(cBuffer, 1, 1 ) ) + ;
       asc( substr(cBuffer, 2, 1 ) ) * ( 256 ) + ;
       asc( substr(cBuffer, 3, 1 ) ) * ( 65536 ) + ;
       asc( substr(cBuffer, 4, 1 ) ) * ( 16777216 )